/* global define */
define(["lib/Zoot", "src/math/Vec2", "src/math/Mat3", "lodash", "src/utils", "src/build/VisualMarks",
	"lib/tasks"],
function (Z, vec2, mat3, lodash, utils, VisualMarks,
	tasks) {
	"use strict";

	function getAllFrames (layer, mat_Layer0) {
		var aFrames = tasks.layer.getHandleFrames(layer, mat_Layer0);

		var aMat_Frame = lodash(aFrames).map(lodash.property("matrix")).value();

		return aMat_Frame;
	}

	function getLeafFrames (layer, mat_Layer0) {
		var tree = layer.getHandleTreeArray(),
			aLeafRef = tree.getLeafRefArray();

		var aFrames = tasks.layer.getHandleFrames(layer, mat_Layer0);

		var aMatTo_Leaf = lodash(aFrames).at(aLeafRef).map(lodash.property("matrix")).value();

		return aMatTo_Leaf;
	}

	function getFrames (layer, mat_Layer0) {
		return getAllFrames(layer, mat_Layer0);
		// return getLeafFrames(layer, mat_Layer0);
	}

	function forEachShownLayer (self, args, fn) {

		var classIndex = 0;
		self.showLayers.forEach(function (sdkLayer) {
			var layer = sdkLayer.privateLayer.getWarperLayer();
			fn(layer, classIndex++);
		});
	}


	function update (self, args) {

		var markIndex = 0;
		forEachShownLayer(self, args, function (layer) {

			var aMatScene_Frame = getFrames(layer, args.getLayerMatrixRelativeToScene(layer));

			aMatScene_Frame.forEach(function (matScene_Frame) {
				var mark = self.leafMarks.getMarkAtIndex(markIndex++);
				mark.setMatrix(matScene_Frame);
			});

		});

	}

	function create (self, args) {
		self.leafMarks = new VisualMarks({ opacity : self.opacity / 100 });

		forEachShownLayer(self, args, function (layer, classIndex) {

			var aMatScene_Frame = getFrames(layer, args.getLayerMatrixRelativeToScene(layer));
			aMatScene_Frame.forEach(function (matScene_Frame) {
				var mark = self.leafMarks.square(self.markSize, classIndex);
				self.leafMarks.insertMark(mark);
				mark.setMatrix(matScene_Frame);
			});

		});

		self.leafMarks.addToDisplayItem(args.stageLayer.privateLayer.getTrackItem());
	}

	function remove (self, args) {
		if (self.leafMarks) {
			self.leafMarks.removeFromDisplayItem(args.stageLayer.privateLayer.getTrackItem());
			self.leafMarks = null;
		}
	}

	var zStringPrefix = "$$$/private/animal/Behavior/ShowHandles/";

	return {
		about: zStringPrefix + "About=ShowHandles, (c) 2016.",
		description: zStringPrefix + "Desc=Shows layers handles",
		uiName: 	zStringPrefix + "UIName=Show Handles",
		defaultArmedForRecordOn: false,
		hideInBehaviorList: true,

		defineTags: function () {
			return {
				aTags: [
					{
						id: "Adobe.ShowHandles.Layer",
						artMatches: [],
						uiName: zStringPrefix + "UIName/ShowLayer=Show Layer",
						tagType: "layertag"
					},					
				]
			};
		},
		
		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			var params = [
				{
					id : "markSize",
					type : "slider",
					uiName: zStringPrefix + "Parameter/markSize=Mark Size",
					min : 1,
					max : 100,
					dephault : 20
				},
				{
					id : "opacity",
					type : "slider",
					uiName: zStringPrefix + "Parameter/opacity=Opacity",
					uiUnits : "%",
					min : 0,
					max : 100,
					precision : 0,
					dephault : 50
				},
				{
					id : "showLayers",
					type : "layer", 
					uiName : "Show Layers",
					dephault : { match : "//Adobe.ShowHandles.Layer"},
					maxCount : 12
				}				
			];

			return params;
		},

		onCreateBackStageBehavior: function (/*self*/) {
			return { order: 22.0, importance : 0.0 }; // must come after others
		},

		onCreateStageBehavior: function (self, args) {
			self.showLayers = args.getStaticParam("showLayers");
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			var markSize = args.getParam("markSize"),
				opacity = args.getParam("opacity");

			if (lodash.isEmpty(self.showLayers)) return;

			if (self.leafMarks) {
				update(self, args);
			} else {
				self.markSize = markSize;
				self.opacity = opacity;
				create(self, args);
			}
		}

	}; // end of object being returned
});
